# The Elastic Lottery Ticket Hypothesis

### Environment

Recommend to create a conda environment and install the following:
* Python 3.7.11
* Pytorch 1.8.0 (GPU-enabled version)

In some cases, the package ```request``` might be missing in the environment. To install request,
```
python -m pip install requests
```

### TODO for Supplementary Material
```
python open_lth.py lottery --default_hparams=cifar_resnet_20_128 --levels=10 --replicate=2
python open_lth.py lottery --default_hparams=cifar_resnet_20_128 --levels=10 --pruning_strategy=random_global --replicate=2

python open_lth.py lottery --default_hparams=cifar_resnet_20_128 --levels=10 --replicate=3
python open_lth.py lottery --default_hparams=cifar_resnet_20_128 --levels=10 --pruning_strategy=random_global --replicate=3
```
Make sure running the two commands with replicate=2 first so that each experiment has at least one run. 

### Test the environment is installed successfully
Simple run
```
python open_lth.py
```
In response, you will see the following message.

```
==================================================================================
OpenLTH: A Framework for Research on Lottery Tickets and Beyond
----------------------------------------------------------------------------------
Choose a command to run:
    * open_lth.py train [...] => Train a model.
    * open_lth.py lottery [...] => Run a lottery ticket hypothesis experiment.
    * open_lth.py lottery_branch [...] => Run a lottery branch.
==================================================================================
```

### TODO for Now[Finished]
```
python open_lth.py lottery --default_hparams=cifar_resnet_50 --levels=16 --replicate=1
python open_lth.py lottery --default_hparams=cifar_resnet_50 --levels=16 --replicate=2
python open_lth.py lottery --default_hparams=cifar_resnet_50 --levels=16 --replicate=3

python open_lth.py lottery --default_hparams=cifar_resnet_50 --levels=16 --pruning_strategy=random_global --replicate=1
python open_lth.py lottery --default_hparams=cifar_resnet_50 --levels=16 --pruning_strategy=random_global --replicate=2
python open_lth.py lottery --default_hparams=cifar_resnet_50 --levels=16 --pruning_strategy=random_global --replicate=3
```

### Welcome

This repo includes codes for the official implementation of the paper [*The Elastic Lottery Ticket Hypothesis*](https://arxiv.org/abs/2103.16547), by Xiaohan Chen, Yu Cheng, Shuohang Wang, Zhe Gan, Jingjing Liu, Zhangyang Wang.

This code base is created by Xiaohan Chen during his time as an reserach intern at Microsoft Corporation in Fall 2020. The implementation is heavily based on [Jonathan Frankle's implemenation](https://github.com/facebookresearch/open_lth) for experiments on the lottery ticket hypothesis.

### Citation

If you use this library in a research paper, please cite this repository.

### License

ElasticLTH is licensed under the MIT license, as found in the LICENSE file.

## Table of Contents

More information is coming soon.

## <a name=acknowledgements></a>Acknowledgements

Thank you to all collaborators and my advisor for the efforts and suggestions put in this work. Thank you for my College Tianlong Chen for supports on lottery ticket hypothesis experiments. Thank you to Microsoft Corporation for supporting this research work, providing sufficient computational resources and allowing me to open-source this framework.
